<?php
// api/get_users.php - Get all users
header('Content-Type: application/json');
require_once '../config.php';

$data = json_decode(file_get_contents('php://input'), true);
$token = $data['token'] ?? '';
$user_id = filter_var($data['user_id'] ?? 0, FILTER_VALIDATE_INT);

if (!$user_id || !$token) {
    http_response_code(400);
    echo json_encode(['error' => 'User ID and token required']);
    exit;
}

$pdo = getDB();
checkRateLimit($pdo, $user_id, 'get_users');

$verified_user_id = verifyJWT($token);
if ($verified_user_id !== $user_id) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token']);
    exit;
}

$stmt = $pdo->prepare("SELECT id, email FROM users WHERE id != :id");
$stmt->execute(['id' => $user_id]);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

http_response_code(200);
echo json_encode(['users' => $users]);
?>