<?php
// Database configuration
class Database {
    private $host = 'localhost';
    private $db_name = 'garmnbhv_flutter';
    private $username = 'garmnbhv_flutterapp'; // Change as needed
    private $password = 'flutterapp577@'; // Change as needed
    private $conn;

    public function getConnection() {
        $this->conn = null;
        
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name,
                $this->username,
                $this->password
            );
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch(PDOException $exception) {
            echo "Connection error: " . $exception->getMessage();
        }
        
        return $this->conn;
    }
}

// Helper functions
function sendResponse($data, $status_code = 200) {
    http_response_code($status_code);
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
    echo json_encode($data);
    exit;
}

function handleCors() {
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        http_response_code(200);
        exit;
    }
}

function getRequestData() {
    $input = file_get_contents('php://input');
    return json_decode($input, true);
}

function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

function hashPassword($password) {
    return password_hash($password, PASSWORD_BCRYPT);
}

function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

function generateToken($user_id) {
    return bin2hex(random_bytes(32)) . '_' . $user_id . '_' . time();
}

function updateUserOnlineStatus($pdo, $user_id, $is_online = true) {
    try {
        // Update user's online status in users table
        $stmt = $pdo->prepare("UPDATE users SET is_online = ?, last_seen = NOW() WHERE id = ?");
        $stmt->execute([$is_online, $user_id]);
        
        // Update or insert online status in actions table
        $stmt = $pdo->prepare("INSERT INTO actions (user_id, isOnline) VALUES (?, ?) 
                              ON DUPLICATE KEY UPDATE isOnline = ?, updated_at = NOW()");
        $stmt->execute([$user_id, $is_online, $is_online]);
        
        return true;
    } catch(Exception $e) {
        return false;
    }
}

function createUserFolder($email) {
    $safe_email = preg_replace('/[^a-zA-Z0-9@._-]/', '', $email);
    $user_folder = 'uploads/' . $safe_email;
    
    if (!file_exists($user_folder)) {
        mkdir($user_folder, 0755, true);
        mkdir($user_folder . '/chat', 0755, true);
        mkdir($user_folder . '/backup', 0755, true);
        mkdir($user_folder . '/backup/videoRecordings', 0755, true);
        mkdir($user_folder . '/backup/voiceRecordings', 0755, true);
        mkdir($user_folder . '/contacts', 0755, true);
        mkdir($user_folder . '/images', 0755, true);
        mkdir($user_folder . '/videos', 0755, true);
        mkdir($user_folder . '/documents', 0755, true);
        mkdir($user_folder . '/audio', 0755, true);
        mkdir($user_folder . '/voice_messages', 0755, true);
    }
    
    return $user_folder;
}

function calculateFileHash($file_path) {
    return hash_file('sha256', $file_path);
}

function logError($message) {
    error_log(date('Y-m-d H:i:s') . ' - ' . $message . PHP_EOL, 3, 'error.log');
}
?>