<?php
require_once '../config/database.php';

handleCors();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(['error' => 'Method not allowed'], 405);
}

try {
    $headers = getallheaders();
    if ($headers === false) {
         $headers = [];
         foreach ($_SERVER as $name => $value) {
            if (substr($name, 0, 5) == 'HTTP_') {
                $headerKey = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
                $headers[$headerKey] = $value;
            }
        }
    }
    
    $user_id = getUserIdFromHeaders($headers);
    
    if (!$user_id) {
        sendResponse(['error' => 'User not authenticated'], 401);
    }
    
    if (!isset($_FILES['recording']) || $_FILES['recording']['error'] !== UPLOAD_ERR_OK) {
        sendResponse(['error' => 'No recording file uploaded'], 400);
    }
    
    $recording_type = $_POST['type'] ?? '';
    if (!in_array($recording_type, ['video', 'voice'])) {
        sendResponse(['error' => 'Invalid recording type. Must be video or voice'], 400);
    }
    
    $database = new Database();
    $pdo = $database->getConnection();
    
    $stmt = $pdo->prepare("SELECT email FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    
    if (!$user) {
        sendResponse(['error' => 'User not found'], 404);
    }
    
    $email = $user['email'];
    $safe_email = preg_replace('/[^a-zA-Z0-9@._-]/', '', $email);
    
    createUserFolder($email);
    
    $upload_file = $_FILES['recording'];
    $file_extension = pathinfo($upload_file['name'], PATHINFO_EXTENSION);
    
    $allowed_extensions = [
        'video' => ['mp4', 'mov', 'avi', 'mkv', '3gp'],
        'voice' => ['mp3', 'wav', 'm4a', 'aac', 'ogg']
    ];
    
    if (!in_array(strtolower($file_extension), $allowed_extensions[$recording_type])) {
        sendResponse(['error' => 'Invalid file type for ' . $recording_type . ' recording'], 400);
    }
    
    $timestamp = date('Y-m-d_H-i-s');
    $unique_id = uniqid();
    $filename = "{$recording_type}_recording_{$timestamp}_{$unique_id}.{$file_extension}";
    
    $upload_dir = "uploads/{$safe_email}/backup/{$recording_type}Recordings/";
    $upload_path = $upload_dir . $filename;
    
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    if (move_uploaded_file($upload_file['tmp_name'], $upload_path)) {
        $file_hash = md5_file($upload_path); // A more standard hash
        $file_size = filesize($upload_path);
        
        $stmt = $pdo->prepare("INSERT INTO files 
            (user_id, file_name, file_path, file_type, file_size, file_hash, mime_type, category, upload_status) 
            VALUES (?, ?, ?, ?, ?, ?, ?, 'backup', 'completed')");
        
        $file_type = $recording_type === 'video' ? 'video' : 'audio';
        $mime_type = $upload_file['type'];
        
        $stmt->execute([
            $user_id,
            $filename,
            $upload_path,
            $file_type,
            $file_size,
            $file_hash,
            $mime_type
        ]);
        
        $file_id = $pdo->lastInsertId();
        
        // [FIX] REMOVED: The client is responsible for setting the recording state.
        // This prevents a race condition where an upload could incorrectly turn off recording.
        /*
        $recording_field = $recording_type === 'video' ? 'isCamRecording' : 'isVoiceRecording';
        $stmt = $pdo->prepare("UPDATE actions SET {$recording_field} = FALSE, updated_at = NOW() WHERE user_id = ?");
        $stmt->execute([$user_id]);
        */
        
        sendResponse([
            'success' => true,
            'message' => ucfirst($recording_type) . ' recording uploaded successfully',
            'file_id' => $file_id,
            'filename' => $filename,
            'file_path' => $upload_path,
            'file_size' => $file_size
        ]);
        
    } else {
        sendResponse(['error' => 'Failed to save recording file'], 500);
    }
    
} catch (Exception $e) {
    logError('Error uploading recording: ' . $e->getMessage());
    sendResponse(['error' => 'Failed to upload recording'], 500);
}

function getUserIdFromHeaders($headers) {
    $token = null;
    $authHeaderKey = array_filter(array_keys($headers), function($key) {
        return strtolower($key) === 'authorization' || strtolower($key) === 'x-auth-token';
    });

    if (!empty($authHeaderKey)) {
        $key = reset($authHeaderKey);
        $token = str_replace('Bearer ', '', $headers[$key]);
    }
    
    if ($token) {
        $parts = explode('_', $token);
        if (count($parts) >= 2) {
            return intval($parts[1]);
        }
    }
    return null;
}
?>
